# User applications to cover with implementation

The minimal specification is only considered useful if it is possible an efficiently implement a service to solve each of the following use cases.

## Web search

* web search engine
* portal search
* library catalogue

## Collaboration

### Engineering

* version controlled source code project, releases, code review, issue tracker
* web page source syntax validator, pretty printer

### Literary

* wiki editing
* collaborative fan fiction

### Sheets

* secuchart

## Personal information management

* contacts
* personal diet scheduling
* personal calendar, alarms
* private file storage, file manager, backup, optional sharing

## Communication

* webmail
* end to end encryption

### Social networking services

* microblog, blog
* group eventing
* social bookmarking
* forum (mailing list)
* group chat
* media gallery sharing
* multiplayer games
* review and recommendation of products, services and vendors

## Entertainment

* puzzles
* comics
* serial fiction stories
* charting social dynamics simulation

## Education

interactive programming courses:

* PHP
* busybox sh, awk shell scripting
* JavaScript (ucode)
* regexp
* flash card spaced repetition learning
* quiz

### Learn morse code

Morse code keying drills: input through pressing enter rhythmically, by typing in dots and dashes or by whistling or tapping into the microphone.

Output dots, dashes, a blinking character or perhaps play back generated sound.

## Business

* webshop
* classified ads marketplace
* interactive site builder for a company or association
* web hosting, web shell command line
* banking, donations
* CAPTCHA

## Consumption

* metacircular web browser
* headless web browser engine library for scraping: search engine crawler, monitoring tool, automated full stack testing
* news portal
* weather forecasting
* stock prices
* feed aggregator

## Ephemeral sharing

* text snippet sharing
* ephemeral image or file sharing

## Mapping

* POI finder around location
* routing directions, turn by turn navigation
* ASCII art neighborhood visualizer
* Description for the visual impaired
* Contribution
* Static public transport schedule timetable
* Real time public transport fleet tracking

## Productivity

* spell checking
* ASCII art editor
* pixel art editor
* raster font editor
* publishing: business card editor, periodicals

### Calculator

* celestial sundown, moon phase, tides, UV radiation
* average annual temperature and precipitation
* average day vs. night temperature per day of year
* agricultural timing, flowering, ripening
* allergens per time of year
* plant classifier based on leaves, flowers, fruit, branching
* tax
* machine translation (dictionary)
